/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.humanoid;

import com.google.inject.ProvidedBy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetDictionaryProvider;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetsByProfession;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetsByType;
import technology.rocketjump.undermount.assets.entities.humanoid.model.HumanoidEntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;
import technology.rocketjump.undermount.jobs.model.Profession;

@ProvidedBy(value=HumanoidEntityAssetDictionaryProvider.class)
public class HumanoidEntityAssetDictionary {
    private final HumanoidEntityAssetsByType typeMap;
    private final Map<String, HumanoidEntityAsset> assetsByName = new HashMap<String, HumanoidEntityAsset>();

    public HumanoidEntityAssetDictionary(List<HumanoidEntityAsset> completeAssetList, EntityAssetTypeDictionary entityAssetTypeDictionary) {
        this.typeMap = new HumanoidEntityAssetsByType(entityAssetTypeDictionary);
        for (HumanoidEntityAsset asset : completeAssetList) {
            this.typeMap.add(asset);
            this.assetsByName.put(asset.getUniqueName(), asset);
        }
        this.assetsByName.put(HumanoidEntityAssetsByProfession.NULL_ENTITY_ASSET.getUniqueName(), HumanoidEntityAssetsByProfession.NULL_ENTITY_ASSET);
    }

    public HumanoidEntityAsset getByUniqueName(String uniqueAssetName) {
        HumanoidEntityAsset asset = this.assetsByName.get(uniqueAssetName);
        if (asset != null) {
            return asset;
        }
        System.err.println("Could not find asset by name " + uniqueAssetName);
        return HumanoidEntityAssetsByProfession.NULL_ENTITY_ASSET;
    }

    public HumanoidEntityAsset getHumanoidEntityAsset(EntityAssetType assetType, HumanoidEntityAttributes attributes, Profession primaryProfession) {
        return this.typeMap.get(assetType, attributes, primaryProfession);
    }

    public List<HumanoidEntityAsset> getAllMatchingAssets(EntityAssetType assetType, HumanoidEntityAttributes attributes, Profession primaryProfession) {
        return this.typeMap.getAll(assetType, attributes, primaryProfession);
    }
}

